/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.init;

import com.finallion.graveyard.entites.AcolyteEntity;
import com.finallion.graveyard.entites.BaseGhoulEntity;
import com.finallion.graveyard.entites.ReaperEntity;
import com.finallion.graveyard.entites.SkeletonCreeper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="graveyard", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TGEntities {
    public static Set<EntityType<?>> entities = new HashSet();
    public static final EntityType<SkeletonCreeper> SKELETON_CREEPER = TGEntities.createEntity("skeleton_creeper", EntityType.Builder.func_220322_a(SkeletonCreeper::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.7f).func_206830_a("graveyard:skeleton_creeper"));
    public static final EntityType<AcolyteEntity> ACOLYTE = TGEntities.createEntity("acolyte", EntityType.Builder.func_220322_a(AcolyteEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.9f).func_206830_a("graveyard:acolyte"));
    public static final EntityType<ReaperEntity> REAPER = TGEntities.createEntity("reaper", EntityType.Builder.func_220322_a(ReaperEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.5f, 1.4f).func_206830_a("graveyard:reaper"));
    public static final EntityType<BaseGhoulEntity> GHOUL = TGEntities.createEntity("ghoul", EntityType.Builder.func_220322_a(BaseGhoulEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.8f, 2.1f).func_206830_a("graveyard:ghoul"));

    public static <E extends Entity, ET extends EntityType<E>> ET createEntity(String id, ET entityType) {
        entityType.setRegistryName(new ResourceLocation("graveyard", id));
        entities.add(entityType);
        return entityType;
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        entities.forEach(entityType -> event.getRegistry().register((IForgeRegistryEntry)entityType));
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(SKELETON_CREEPER, SkeletonCreeper.createAttributes().func_233813_a_());
        event.put(ACOLYTE, AcolyteEntity.createAttributes().func_233813_a_());
        event.put(GHOUL, BaseGhoulEntity.createAttributes().func_233813_a_());
        event.put(REAPER, ReaperEntity.createAttributes().func_233813_a_());
    }

    static {
        EntitySpawnPlacementRegistry.func_209343_a(SKELETON_CREEPER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(GHOUL, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BaseGhoulEntity::checkMonsterSpawnRules);
        EntitySpawnPlacementRegistry.func_209343_a(ACOLYTE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(REAPER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
    }
}

